<?php
session_start();
require("functions.php");
include('translatecountryname.php');

$config = loadConfig();
unlock_all_files();
$timestamp = time();
$action = $_GET['action'];

if(ismobile() AND isset($_GET['webapp'])) {
setcookie('webapp_installed','true');
}

if($action=="logout" AND opolytics_check_csrf($_GET['csrf'])) {
session_destroy();
echo '<script>window.location.href = "login.php?reason=logout";</script>';
die();
}
if($_GET['action']=="reset") {
	if($_SESSION['user']==$config[1]) {
		file_put_contents('log.txt','');
		echo '<!DOCTYPE html><html lang="de"><head><meta name="viewport" content="width=device-width, initial-scale=1.0"><link rel="Shortcut Icon" href="opolytics.png"><title>Daten zurückgesetzt - Opolytics</title><link rel="Stylesheet" href="style.php" type="text/css"></head><body>';
		include('updater.php');
		include('menu.php');
		echo '<h1>Daten zurückgesetzt</h1><p>Alle Tracking-Daten wurden soeben erfolgreich entfernt.<br><br><a href="javascript:window.history.back();">Zurück</a></body></html>';
	}
	else {
		echo '<!DOCTYPE html><html lang="de"><head><meta name="viewport" content="width=device-width, initial-scale=1.0"><link rel="Shortcut Icon" href="opolytics.png"><title>Daten zurückgesetzt - Opolytics</title><link rel="Stylesheet" href="style.php" type="text/css"></head><body>';
		include('updater.php');
		include('menu.php');
		echo '<h1>Unzureichende Berechtigung</h1><p>Sie müssen ein Administrator sein, um die Daten zurückzusetzen.</p>';
	}
}

if(o_login_check($_POST['user'],$_POST['password']) OR o_login_check($_SESSION['user'],$_SESSION['password'])) {

opolytics_activate_security();

if(isset($_POST['user'])) {
$_SESSION['user'] = $_POST['user'];
$_SESSION['password'] = $_POST['password'];
}

if(ismobile() AND $_COOKIE['webapp_installed']!='true' AND !isset($_GET['webapp'])) {
header('Location: installwebapp.php');
}

if($action=="change_cards" AND !isset($_POST['1'])) {
echo '<!DOCTYPE html><html lang="de"><head><title>Opolytics - Ihr nutzerfreundlicher Tracking-Dienst</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body onload="draw()"><meta name="viewport" content="initial-scale=1">';

// Checking updates
include("updater.php");

if(!isset($_GET['hide'])) {
// Include the menubar
include("menu.php");
}

echo '<h1>Karten ein-/ausblenden</h1><form action="?action=change_cards" method="post" style="padding: 0px 0px 0px 0px; box-shadow: none;"><table align="center"><tr><td><img src="img/check.png" width="40"></td><td><img src="img/cross.png" width="40"></td><td><h3>Element</h3></td></tr>
<tr><td><input type="radio" id="0" value="true" name="0" checked></td><td><input type="radio" id="0" value="false" name="0"></td><td>Entwicklungen in der Anzahl Nutzer</td></tr>
<tr><td><input type="radio" id="1" value="true" name="1" checked></td><td><input type="radio" id="1" value="false" name="1"></td><td>Rangliste der Seitenaufrufe</td></tr>
<tr><td><input type="radio" id="2" value="true" name="2" checked></td><td><input type="radio" id="2" value="false" name="2"></td><td>Rangliste der Herkünfte</td></tr>
<tr><td><input type="radio" id="3" value="true" name="3" checked></td><td><input type="radio" id="3" value="false" name="3"></td><td>Top verwendete Suchmaschinen und Suchbegriffe</td></tr>
<tr><td><input type="radio" id="4" value="true" name="4" checked></td><td><input type="radio" id="4" value="false" name="4"></td><td>Sprachenrangliste</td></tr>
<tr><td><input type="radio" id="5" value="true" name="5" checked></td><td><input type="radio" id="5" value="false" name="5"></td><td>Oft auf Ihrer Seite gesucht</td></tr>
<tr><td><input type="radio" id="6" value="true" name="6" checked></td><td><input type="radio" id="6" value="false" name="6"></td><td>Letzte Aufrufe</td></tr>
</table><p><input type="submit" value="Speichern"></p></form>
<style>
table[align=center] {
font-weight: bold;
}
</style>';
}
if($action=="new_notice") {
$comments_enabled = $_POST['comments_enabled'];
if($comments_enabled=="on") {
$comments_enabled = "true";
}
else {
$comments_enabled = "false";
}
$visiblefor = $_POST['visiblefor'];
if($visiblefor=='defined_users') {
$visiblefor = $_POST['users'];
}
else if($visiblefor=='me') {
$visiblefor = $_SESSION['user'];
}
$xml = load_compressed_xml_file('notes.xml');
$notice = $xml->addChild('notice');
$notice->addAttribute('visibleon', $_POST['visibleon']);
$notice->addAttribute('visiblefor', $visiblefor);
$notice->addAttribute('comments_enabled', $comments_enabled);
$notice->addChild('comments');
$notice->addChild('date',date("d.m.Y H:i",time()));
$notice->addChild('from',$_SESSION['user']);
$notice->addChild('content',$_POST['content']);
save_compressed_xml_file($xml,'notes.xml');
// Checking updates
include("updater.php");
// Include the menubar
include("menu.php");
echo '<!DOCTYPE html><html lang="de"><head><meta http-equiv="refresh" content="3; URL='.$_SERVER['HTTP_REFERER'].'"><title>Kommentar gespeichert - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body onload="draw()"><meta name="viewport" content="initial-scale=1"><h1>Notiz gespeichert</h1><p>Sie kehren in 3 Sekunden automatisch zurück</p>';
}
if($action=="comment_notice") {
$number = intval($_POST['notice']);
$visiblefor = $_POST['visiblefor'];
if($visiblefor=='defined_users') {
$visiblefor = $_POST['users'];
}
else if($visiblefor=='me') {
$visiblefor = $_SESSION['user'];
}
$xml = load_compressed_xml_file('notes.xml');
$comment = $xml->notice[$number]->comments->addChild('comment',$_POST['content']);
$comment->addAttribute('from',$_SESSION['user']);
$comment->addAttribute('visiblefor',$visiblefor);
$comment->addAttribute('date',date("d.m.Y - H:i",time()));
save_compressed_xml_file($xml,'notes.xml');
// Checking updates
include("updater.php");
// Include the menubar
include("menu.php");
echo '<!DOCTYPE html><html lang="de"><head><meta http-equiv="refresh" content="3; URL='.$_SERVER['HTTP_REFERER'].'"><title>Kommentar gespeichert - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body onload="draw()"><meta name="viewport" content="initial-scale=1"><h1>Kommentar gespeichert</h1><p>Sie kehren in 3 Sekunden automatisch zurück</p>';
}
if($action=="change_cards" AND isset($_POST['1'])) {
// Checking updates
include("updater.php");

// Include the menubar
include("menu.php");

$config[12] = $_POST['1'];
$config[13] = $_POST['2'];
$config[14] = $_POST['3'];
$config[15] = $_POST['4'];
$config[16] = $_POST['5'];
$config[17] = $_POST['6'];
$config[18] = $_POST['0'];
$config = implode(', ', $config);
file_put_contents("config.txt", $config);
echo '<!DOCTYPE html><html lang="de"><head><title>Opolytics - Ihr nutzerfreundlicher Tracking-Dienst</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body onload="draw()"><meta name="viewport" content="initial-scale=1">';
echo '<h1>Einstellungen gespeichert.</h1><p>Ihre Einstellungen wurden soeben geändert.</p><p><a href="?">Fortfahren</a></p>';
}
if($_GET['action']=="share") {
$expires = unserialize(file_get_contents("shared/expires.txt"));
if(!isset($_POST['date'])) {
$upload_dir = "shared/";
$img = $_POST['upload'];
$img = str_replace('data:image/png;base64,', '', $img);
$img = str_replace(' ', '+', $img);
$data = base64_decode($img);
$file = "shared/".intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared")))) + 1).".png";
$success = file_put_contents($file, $data);
$img = imagecreatefrompng($file);
$background = imagecreate(intval(imagesx($img) + 10), intval(imagesy($img) + 15));
imagesavealpha($img, true);
imagecopy($background,$img,5,5,0,0,imagesx($img),imagesy($img));
imagestring($background, 2, intval((imagesx($img) + 10) - 180), intval((imagesy($img) + 15) - 18), "Stand vom: ".date("d.m.Y - H:i",time()), imagecolorallocate($background,161,161,161));
imagepng($background, $file);
if($_GET['mode']=="share") {
echo '<!DOCTYPE html><html lang="de"><head><title>Inhalt teilen - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body>';
// Include the menubar
include("menu.php");
echo '<h1>Inhalt teilen</h1><p>Bitte legen Sie fest, wie lange der Inhalt zur Ansicht vorliegt.</p><form action="?action=share&mode='.$_GET['mode'].'" method="post"><b>Inhalt bereitstellen bis: <input type="date" name="date"><br><br><input type="submit" value="Teilen"></form>';
}
if($_GET['mode']=="embed") {
echo '<!DOCTYPE html><html lang="de"><head><title>Inhalt einbetten - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body>';
// Include the menubar
include("menu.php");
echo '<h1>Inhalt einbetten</h1><p>Auch beim Einbetten, haben Sie die Möglichkeit ein Ablaufdatum für den Inhalt festzulegen. Sie können das Ablaufdatum auch deaktivieren (ablauf in 1000 Jahren), wenn Sie kein Ablaufdatum wünschen.</p><form action="?action=share&mode='.$_GET['mode'].'" method="post"><b><input type="checkbox" name="activated" checked> Ablaufdatum festlegen</b><br><b>Inhalt bereitstellen bis: <input type="date" name="date"><br><br><input type="submit" value="Weiter"></form>';
}
}
if(isset($_POST['date']) AND $_GET['mode']=="share") {
$expires[strval(intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared"))))).".png")] = strtotime(implode('.', array_reverse(explode('.', str_replace('-', '.', $_POST['date'])))));
file_put_contents("shared/expires.txt",serialize($expires));
echo '<!DOCTYPE html><html lang="de"><head><title>Inhalt geteilt - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body>';
// Include the menubar
include("menu.php");
echo '<h1>Inhalt geteilt</h1><p>Ihr Inhalt wurde soeben geteilt der Link zum Inhalt lautet: '.strval($_SERVER['SERVER_NAME']."/opolytics/shared/?data=".intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared"))))).".png")."</p>";
}
if(isset($_POST['date']) AND $_GET['mode']=="embed") {
if($_POST['activated']!="on") {
$expires[strval(intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared"))))).".png")] = intval(time() + 31536000000000);
}
if($_POST['activated']=="on") {
$expires[strval(intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared"))))).".png")] = strtotime(implode('.', array_reverse(explode('.', str_replace('-', '.', $_POST['date'])))));
}
file_put_contents("shared/expires.txt",serialize($expires));
echo '<!DOCTYPE html><html lang="de"><head><title>Inhalt geteilt - Opolytics</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body>';
// Include the menubar
include("menu.php");
echo '<h1>Inhalt einbetten</h1><p>Super, der Inhalt, den Sie einbetten wollten steht bereit. Fügen Sie doch den unten stehenden Quellcode ein um den Inhalt einzubetten.</p><p><textarea style="font-family:Arial;font-size:10pt;width:300px;height:150px;"><img src="http://'.strval($_SERVER['SERVER_NAME']."/opolytics/shared/?data=".intval(max(preg_replace('/^$/', '0', preg_replace("/expires.txt|index.php|.png/","",scandir("shared"))))).".png").'" width="100" height="100"></textarea></p><br><h3>Hinweise für Formatierungen</h3><p>Natürlich können Sie diesen Inhalt vergrössern und verkleinern, bzw. anders formatieren. Um die Breite beziehngsweise Höhe Ihres Inhalts anzupassen, können Sie die Attribute "width" und "height" anpassen. Für weitere Formatierungen können Sie alle gängigen HTML- und CSS-Formatierungen verwenden.</p>';
}
}

if(!isset($_GET['action']) AND !isset($_GET['view'])) {
echo '<!DOCTYPE html><html lang="de"><head><script src="js/countrytranslatepackage.min.js" async></script><meta name="viewport" content="initial-scale=1"><title>Opolytics - Ihr nutzerfreundlicher Tracking-Dienst</title><link rel="Shortcut Icon" href="opolytics.png"><link rel="Stylesheet" href="style.php?site=view" type="text/css"></head><body>';

// Checking updates
include("updater.php");

// Include the menubar
include("menu.php");

echo '<h1>Übersicht/Dashboard <a href="javascript:;" OnClick="show_statistics_index()"><img src="img/down.png" height="15" id="show_statistics_index" alt="down"></a></h1><ul style="display:none;background-color:#D5D2D2" id="statistics_index" class="text"><li><a OnClick="scrolldown()" href="#allgemein">Allgemein</a>
<li><a OnClick="scrolldown()" href="#graphen&diagramme">Graphen und Diagramme</a>
<li><a OnClick="scrolldown()" href="#seitenaufrufe">Seitenaufrufe</a>
<li><a OnClick="scrolldown()" href="#herkuenfte">Herkünfte (Referrer)</a>
<li><a OnClick="scrolldown()" href="#suchmaschinen">Suchmaschinenanalyse</a>
<li><a OnClick="scrolldown()" href="#sprachen">Sprachen</a>
<li><a OnClick="scrolldown()" href="#oftgesucht">Oft gesucht</a>
<li><a OnClick="scrolldown()" href="#letzteaufrufe">Letzte Aufrufe</a>
</ul>';

if($action=="reset") {
file_put_contents("log.txt", "");
echo '<script>window.location.href = "view.php";</script>';
}

$file = loadLog();
$file = array_reverse($file);
$live = unserialize(file_get_contents('liveupdate.txt'));
foreach(array_keys($live) AS $key) {
if(intval($live[$key]["timestamp"] + 12) <= time()) {
unset($live[$key]);
}
}

$usingtime = "0";
$mobile = "0";
$desktop = "0";
$breite = "0";
$system = array();
$nutzerip = "";
$nutzer = "0";
$sprachen = "";
$zeit = "";
$meistgenutzt = array();
$bots = "0";
$aufrufe_pro_nutzer = "0";
$Search_Engines = "";
$language = array();
$firefox = "0";
$IE = "0";
$safari = "0";
$chrome = "0";
$opera = "0";
$google = "0";
$bing = "0";
$ask = "0";
$yahoo = "0";
$duckduckgo = "0";
$other_search_engines = "0";
$suchen = array();
$Search_Engines = array();
$referrers = array();

foreach($file AS $durchschnitt) {
$durchschnitt = explode(', ', $durchschnitt);

// Nutzungszeit
$usingtime = $usingtime + $durchschnitt[8];

// Bildschirmbreite
$breite = $breite + $durchschnitt[2];

// Desktop/Mobile
if($durchschnitt[2] > 640) {
$desktop++;
}
if($durchschnitt[2] < 640) {
$mobile++;
}

// Betriebssystem
if(preg_match('/Win/',$durchschnitt[6])) {
$system[] = 'Windows';
}
if(preg_match('/Mac/',$durchschnitt[6])) {
$system[] = 'Macintosh';
}
if(preg_match('/iPhone|iPod|iPad/',$durchschnitt[6])) {
$system[] = 'iOS';
}
if(preg_match('/Android|Linux armv7l/',$durchschnitt[6])) {
$system[] = 'Android';
}
if(preg_match('/Linux/',$durchschnitt[6]) AND !preg_match('/Linux armv7l/',$durchschnitt[6])) {
$system[] = 'Linux';
}

// Einzelne Nutzer
if(strpos($nutzerip, $durchschnitt[1])===false) {
$nutzer++;
$nutzerip = $nutzerip.$durchschnitt[1];
}

// Sprachen
$sprachen = $sprachen.$durchschnitt[5];
$language[] = $durchschnitt[5];

// Zeit
$zeitstring = substr($durchschnitt[9],11);
$zeitstring = substr($zeitstring, 0, -3); 
$zeitstring = str_replace(':', '.', $zeitstring);
$zeit = $zeit + $zeitstring; 

// Meistgenutzte Seite
$meistgenutzt[] = preg_replace('-http[s]?://-','',$durchschnitt[0]);

// Bots
if(strpos($durchschnitt[4], "Bot")!==false OR strpos($durchschnitt[4], "bot")!==false OR strpos($durchschnitt[4], "BUbiNG")!==false) {
$bots++;
}

// Meistinstalliertes Plugin
$meistgenutzes_plugin = $meistgenutzes_plugin." ".$durchschnitt[7];


// referrers
if(strpos($durchschnitt[10], 'google')===false AND strpos($durchschnitt[10], 'bing.com')===false AND strpos($durchschnitt[10], 'ask.com')===false AND strpos($durchschnitt[10], 'yahoo.com')===false AND strpos($durchschnitt[10], 'duckduckgo.com')===false) {
$referrers[] = $durchschnitt[10];
}

// Suchmaschinen
if(strpos($durchschnitt[10], 'google')!==false) {
$Search_Engines[] = "Google=>".$durchschnitt[11]."=>".str_replace(' ', '@opolyticswhitespace', str_replace('_', ',', $durchschnitt[12]))."=>".$durchschnitt[0]."=>".parseGet(parse_url($durchschnitt[10])["query"])["q"];
$search_terms[] = parseGet(parse_url($durchschnitt[10])["query"])["q"];
$searchengines[] = 'Google';
}
if(strpos($durchschnitt[10], 'bing.com')!==false) {
$Search_Engines[] = "Bing=>".$durchschnitt[11]."=>".str_replace(' ', '@opolyticswhitespace', str_replace('_', ',', $durchschnitt[12]))."=>".$durchschnitt[0]."=>".parseGet(parse_url($durchschnitt[10])["query"])["q"];
$search_terms[] = parseGet(parse_url($durchschnitt[10])["query"])["q"];
$searchengines[] = 'Bing';
}
if(strpos($durchschnitt[10], 'ask.com')!==false) {
$Search_Engines[] = "Ask.com=>".$durchschnitt[11]."=>".str_replace(' ', '@opolyticswhitespace', str_replace('_', ',', $durchschnitt[12]))."=>".$durchschnitt[0]."=>".parseGet(parse_url($durchschnitt[10])["query"])["q"];
$search_terms[] = parseGet(parse_url($durchschnitt[10])["query"])["q"];
$searchengines[] = 'Ask.com';
}
if(strpos($durchschnitt[10], 'yahoo.com')!==false) {
$Search_Engines[] = "Yahoo=>".$durchschnitt[11]."=>".str_replace(' ', '@opolyticswhitespace', str_replace('_', ',', $durchschnitt[12]))."=>".$durchschnitt[0]."=>".parseGet(parse_url($durchschnitt[10])["query"])["p"];
$search_terms[] = parseGet(parse_url($durchschnitt[10])["query"])["p"];
$searchengines[] = 'Yahoo';
}
if(strpos($durchschnitt[10], 'duckduckgo.com')!==false) {
$Search_Engines[] = "DuckDuckGo=>".$durchschnitt[11]."=>".str_replace(' ', '@opolyticswhitespace', str_replace('_', ',', $durchschnitt[12]))."=>".$durchschnitt[0]."=>".parseGet(parse_url($durchschnitt[10])["query"])["q"];
$search_terms[] = parseGet(parse_url($durchschnitt[10])["query"])["q"];
$searchengines[] = 'DuckDuckGo';
}

// Browser erkennen
if(preg_match("/MSIE|Media Center|like Gecko/", $durchschnitt[4]) AND !preg_match("/KHTML_ like Gecko/", $durchschnitt[4])) {
$IE++;
}
if(preg_match("/Firefox.[1-9]*.[1-9]{1}/", $durchschnitt[4])) {
$firefox++;
}
if(preg_match("/Safari|safari/", $durchschnitt[4]) AND !preg_match("/Chrome|chrome/", $durchschnitt[4])) {
$safari++;
}
if(preg_match("/Chrome|chrome/", $durchschnitt[4]) AND preg_match("/Safari|safari/", $durchschnitt[4])) {
$chrome++;
}
if(preg_match("/opera|Opera|OPR|opr|Opr/", $durchschnitt[4])) {
$opera++;
}

// Oft gesucht
if(preg_match('/search[.php|.htm|.html]?|suche[n]?[.php|.htm|.html]?/', $durchschnitt[0])) {
$durchschnitt[0] = $durchschnitt[0]."&";
$durchschnitt[0] = substr($durchschnitt[0], strpos($durchschnitt[0], "=")+1, strpos($durchschnitt[0], "&")-strpos($durchschnitt[0], "=")-1);
array_push($suchen, $durchschnitt[0]);
}
// geolocation
$geolocation[] = $durchschnitt[14];
}

// Endberechnung
$usingtime = $usingtime / count($file);
$usingtime = round($usingtime, 1);
$breite = $breite / count($file);
$breite = round($breite, 1);
$system = array_count_values($system);
$sprachen = substr_count ( $sprachen , "de" );
$sprachen = count($file) - $sprachen;
$zeit = $zeit / count($file);
$zeit = round($zeit, 2);
$zeit = str_replace('.', ':', $zeit);
$aufrufe_pro_nutzer = count($file) / $nutzer;

$count = array_count_values($meistgenutzt);
$idlist = array_keys($count, max($count));
$mostused = $idlist[0];

$geolocation = array_count_values($geolocation);
arsort($geolocation);
arsort($system);
$meistgenutzt = array_slice($count,0,4);
$sites = array('names'=>array_keys($meistgenutzt),'numbers'=>array_values($meistgenutzt));

// Ausgabe
echo '<div class="text facts unilateral" style="width:47%;float:right;margin-top:0px">'; include('map.html'); echo ' | <a href="detail.php?view=karte">Mehr</a></div><table class="facts unilateral" style="width:47%;margin-bottom:20px"><tr><td>Durchschnittliche Nutzungszeit</td><td>'.$usingtime.'s</td></tr><tr><td>Beliebteste Seite</td><td>'.$mostused.'</td></tr><tr><td>Häufigstes Herkunftsland</td><td><img src="img/flags/redirect.php?country='.array_keys($geolocation)[0].'" width="10" alt="Flag of '.array_keys($geolocation)[0].'"> '.translateCountryName(array_keys($geolocation)[0],'de').'</td></tr><tr><td>Häufigstes Betriebssystem</td><td>'.array_keys($system)[0].'</td></tr></table><div class="text unilateral" style="width:45%"><table class="hiddentable"><thead><tr><td>Seite</td><td>Seit</td><td></td><td>Land</td><td>Browser</td><td>Betriebssystem</td></tr></thead><tbody id="live">';
foreach($live AS $livecall) {
echo '<tr><td>'.str_replace('https://','',str_replace('http://','',str_replace($_SERVER['SERVER_NAME'],'',$livecall['site']))).'</td><td>'.date("d.m.Y H:i",$livecall['start']).'</td><td><img src="img/flags/redirect.php?country='.$livecall['location'].'" height="15"></td><td>'.translateCountryName($livecall['location'],'de').'</td><td>'.get_browser($livecall['useragent'],true)['browser'].'</td><td>'.get_browser($livecall['useragent'],true)['platform'].'</td></tr>';
}
echo '</tbody></table><span style="font-size:30pt" id="online">'.count($live).' </span><span style="font-size:10pt">Nutzer online</span> <span style="font-size:30pt" id="visitors_today">'.visitors_per_day_strict(date("d.m.Y",time())).'</span> <span style="font-size:10pt">Nutzer heute</span> <span style="font-size:30pt" id="views_today">'.visitors_per_day(date("d.m.Y",time())).' </span><span style="font-size:10pt">Ansichten heute</span><br><br><a href="detail.php?view=live">Mehr</a></div>';
include('visitorgraph.php');
echo '<div class="text unilateral" style="float:left"><span><canvas id="sites" width="500" height="250"></canvas></span><br><a href="detail.php?view=beliebt">Mehr</a></div><div class="text unilateral" style="float:left"><canvas id="desktop" width="500" height="260"></canvas></div><br style="clear:both"><div class="unilateral text" style="float:left"><div><canvas id="searches" width="500" height="300"></canvas></div><a href="detail.php?view=suchmaschinen">Mehr</a></div><div class="unilateral text" style="float:right"><div><canvas id="searchengines" width="500" height="300"></canvas></div><a href="detail.php?view=suchmaschinen">Mehr</a></div><br style="clear:both"><script>
setInterval(function() {
var xhr = new XMLHttpRequest();
xhr.open("GET","getjson.php?context=time&data=live");
xhr.responseType = "json";
xhr.addEventListener("load",function() { document.getElementById("live").innerHTML = ""; var data = this.response;
for (var k in data) {
document.getElementById("live").innerHTML += "<tr><td>" + data[k]["site"].replace("http://","").replace("https://","").replace("'.$_SERVER['SERVER_NAME'].'","") + "</td><td>" + data[k]["startstring"] + "</td><td><img src=\'img/flags/redirect.php?country=" + data[k]["location"] + "\' height=\'15\'></td><td>" + translateCountryName(data[k]["location"],"de") + "</td><td>" + data[k]["browser"] + "</td><td>" + data[k]["platform"] + "</td></tr>";
}
document.getElementById("online").innerHTML = Object.keys(data).length + " ";
});
xhr.send();
var general = new XMLHttpRequest();
general.open("GET","getjson.php?context=day&data=general&reference=" + new Date().getDate() + "." + (new Date().getMonth() + 1) + "." + new Date().getFullYear());
general.responseType = "json";
general.addEventListener("load",function() {
	document.getElementById("visitors_today").innerHTML = this.response["users"] + " ";
	document.getElementById("views_today").innerHTML = this.response["views"] + " ";
});
general.send();
},12000);
var sites = '.json_encode($sites).';
var sum = '.array_sum($sites['numbers']).';
var canvas = document.getElementById("sites");
barchart(canvas,sites["numbers"],sites["names"]);
canvas = document.getElementById("desktop");
piechart(canvas,['.$desktop.','.$mobile.'],["Desktopgeräte","Mobilgeräte"]);
barchart(document.getElementById("searches"),'.json_encode(array_values(array_count_values($search_terms))).','.json_encode(array_keys(array_count_values($search_terms))).');
piechart(document.getElementById("searchengines"),'.json_encode(array_values(array_count_values($searchengines))).','.json_encode(array_keys(array_count_values($searchengines))).');
</script>';
}
include('notes.php');
}

else {
//header('HTTP/1.0 401 Unauthorized');
header('location: login.php?reason=err_password_not_matching');
}
include("contextmenu.php");
include('footer.php');
?>