function scrolldown() {
setTimeout(function() { window.scrollBy(0,-1000); },10)
var interval = setInterval(function() { window.scrollBy(0, 10); }, 10);
setTimeout(function() { clearInterval(interval); }, 1000);
}
function show_statistics_index() {
element = document.getElementById("show_statistics_index");
if(document.getElementById("statistics_index").style.display=="none") {
document.getElementById("statistics_index").style.display = "block";
element.src = "img/up.png";
}
else {
document.getElementById("statistics_index").style.display = "none";
element.src = "img/down.png";
}
}
function arraySum(array) {
	var i;
	var sum = 0;
	for (i = 0; i < array.length; i++) {
		sum = sum + array[i];
	}
	return sum;
}
function arrayPercent(array) {
	var sum = arraySum(array);
	var i;
	for (i = 0; i < array.length; i++) {
		array[i] = array[i] / sum * 100;
	}
	return array;
}
function arrayCombine(keys,values) {
	var data = {};
	var i;
	for (i = 0; i < keys.length; i++) {
		data[keys[i]] = values[i];
	}
	return data;
}
function clearUrl(url) {
	return url.toString().replace("http://","").replace("https://","").replace(window.location.hostname,"");
}
function convertHexa(number) {
	return number.toString(16).toUpperCase();
}
function rgbToHexa(r,g,b) {
	return "#" + convertHexa(r) + convertHexa(g) + convertHexa(b);
}
const colors = ["#EA3E35","#EA6A37","#F5D221","#8DEF38","#26CB13","#31FDE5","#2353F3","#652FED","#A828F4","#E622A5","#EA3E35","#EA6A37","#F5D221","#8DEF38","#26CB13","#31FDE5","#2353F3","#652FED","#A828F4","#E622A5","#EA3E35","#EA6A37","#F5D221","#8DEF38","#26CB13","#31FDE5","#2353F3","#652FED","#A828F4","#E622A5"];
function setShadow(mode,ctx,offsetY) {
	switch(mode) {
		case "no-shadow":
			ctx.shadowColor = "rgba(0,0,0,0)";
		break;
		case "light-shadow":
			ctx.shadowColor = "rgba(0,0,0,0.2)";
		break;
		case "shadow":
		default:
			ctx.shadowColor = "rgba(0,0,0,0.5)";
		break;
		break;
	}
	ctx.shadowOffsetX = 2;
	if(offsetY!=false) ctx.shadowOffsetY = 2; else ctx.shadowOffsetY = 0;
	ctx.shadowBlur = 5;
	return true;
}
function graphBackground(canvas,data,names) {
	var ctx = canvas.getContext("2d");
	setShadow("no-shadow",ctx);
	ctx.clearRect(0,0,canvas.width,canvas.height);
	ctx.fillStyle = "#DBD9D9";
	ctx.fillRect(0,canvas.height-50,canvas.width,1);
	ctx.fillRect(Math.max(...data).toString().length * 8 + 8,10,canvas.width,1);
	ctx.fillRect((Math.max(...data) * 0.25).toString().length * 8 + 8, Math.round((canvas.height - 50) / 4),canvas.width,1);
	ctx.fillRect((Math.max(...data) * 0.5).toString().length * 8 + 8, Math.round(2 * ((canvas.height - 50) / 4)),canvas.width,1);
	ctx.fillRect((Math.max(...data) * 0.25).toString().length * 8 + 8, Math.round(3 * ((canvas.height - 50) / 4)),canvas.width,1);
	ctx.font = "15px Arial";
	ctx.fillStyle = "grey";
	ctx.fillText(Math.max(...data),5,15);
	ctx.fillText((Math.max(...data) * 0.75),5,(canvas.height - 50) / 4 + 5);
	ctx.fillText((Math.max(...data) * 0.5),5,2 * ((canvas.height - 50) / 4) + 5);
	ctx.fillText((Math.max(...data) * 0.25),5,3 * ((canvas.height - 50) / 4) + 5);
	var i;
	for (i = 0; i < names.length; i++) { 
		ctx.fillStyle = "#DBD9D9";
		ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)),10,1,canvas.height-60);
		ctx.fillStyle = "grey";
		ctx.fillText(clearUrl(names[i]),(i + 1) * (canvas.width / (names.length + 1)) - (clearUrl(names[i]).length * 8 / 2),canvas.height - 30);
	}
}
var canvasStats = {};
function changeGraph(canvas,to,data,names) {
	to = to.options[to.selectedIndex].value;
	if(to=="piechart") {
		piechart(canvas,data,names);
		canvasStats[canvas.id] = "piechart";
	}
	else if(to=="barchart") {
		canvasStats[canvas.id] = "barchart";
		barchart(canvas,data,names);
	}
	else if(to=="evolution") {
		canvasStats[canvas.id] = "evolution";
		evolution(canvas,data,names,false);
	}
	else if(to=="table") {
		var csv = "Name,Value\n";
		var tsv = "Name	Value\n";
		var i;
		for (i = 0; i < names.length; i++) {
			csv += names[i] + "," + data[i] + "\n";
			tsv += names[i] + "	" + data[i] + "\n";
		}
		csv = window.btoa(csv);
		tsv = window.btoa(tsv);
		var text = "<table class='hiddentable'><thead><tr><td>Name</td><td>Wert</td></tr></thead><tbody>";
		var i;
		for (i = 0; i < names.length; i++) {
			text += "<tr><td>" + names[i] + "</td><td>" + data[i]+ "</tr>";
		}
		text += "</tbody></table>";
		popup("<h1>Darstellung in Tabelle</h1><div style='max-height:100%;overflow:auto'>" + text + "<br>Download as <a href='data:text/comma-separated-values;base64," + csv + "'>CSV</a> | <a href='data:application/vnd.ms-excel;base64," + tsv + "'>TSV (für Excel)</a> | <a href='data:application/json," + JSON.stringify(arrayCombine(names,data)) + "' download>JSON</a> | <a href='data:text/html;base64," + window.btoa(text) + "' download>HTML</a></div>",screen.width / 2 - 400,screen.height / 2 - 200,800,400);
	}
	else if(to=="evolution+base") {
		canvasStats[canvas.id] = "evolution+base";
		evolution(canvas,data,names,true);
	}
	else {
		alert("Bitte wählen Sie eine Möglichkeit");
	}
}
function exportGraph(canvas,select,data,names) {
	canvasStats[canvas.id] = select.options[select.selectedIndex].value;
	function exportPopup() {
		popup("<h1>Download als Grafik</h1>Bitte bestätigen Sie den Download<br><br><img src='" + canvas.toDataURL("image/png") + "' style='max-width:80%;max-height:200px'><br>Vorschau<br><br><a href='" + canvas.toDataURL("image/png") + "' download>Herunterladen</a>",screen.width / 2 - 300,screen.height / 2 - 200,600,400);
	}
	switch(select.options[select.selectedIndex].value) {
		case "nochange":
		alert("Bitte wählen Sie eine Möglichkeit");
		break;
		case "piechart":
		piechart(canvas,data,names);
		exportPopup();
		break;
		case "barchart":
		barchart(canvas,data,names);
		exportPopup();
		break;
		case "act": 
		exportPopup();
		break;
		case "evolution":
		evolution(canvas,data,names);
		exportPopup();
		break;
		case "evolution+base":
		evolution(canvas,data,names,true);
		exportPopup();
		break;
		case "csv":
		var csv = "Name,Value\n";
		var i;
		for (i = 0; i < names.length; i++) {
			csv += names[i] + "," + data[i] + "\n";
		}
		csv = window.btoa(csv);
		popup("<h1>Download als CSV</h1><a href='data:text/comma-separated-values;base64," + csv + "' download>Herunterladen</a>",screen.width / 2 - 300,screen.height / 2 - 200,600,400);
		break;
		case "tsv":
		var tsv = "Name	Value\n";
		var i;
		for (i = 0; i < names.length; i++) {
			tsv += names[i] + "	" + data[i] + "\n";
		}
		tsv = window.btoa(tsv);
		popup("<h1>Download als TSV (für Excel)</h1><a href='data:application/vnd.ms-excel;base64," + tsv + "' download>Herunterladen</a>",screen.width / 2 - 300,screen.height / 2 - 200,600,400);
		break;
		case "json":
		popup("<h1>Download als JSON</h1><textarea readonly>" + JSON.stringify(arrayCombine(names,data)) + "</textarea><br>Vorschau<br><br><a href='data:application/json," + JSON.stringify(arrayCombine(names,data)) + "' download>Herunterladen</a>",screen.width / 2 - 300,screen.height / 2 - 200,600,400);
		break;
		case "html":
		var text = "<table class='hiddentable'><thead><tr><td>Name</td><td>Wert</td></tr></thead><tbody>";
		var i;
		for (i = 0; i < names.length; i++) {
			text += "<tr><td>" + names[i] + "</td><td>" + data[i]+ "</tr>";
		}
		text += "</tbody></table>";
		popup("<h1>Download als HTML</h1>" + text + "<br><br><a href='data:text/html;base64," + window.btoa(text) + "' download>Herunterladen</a>",screen.width / 2 - 300,screen.height / 2 - 200,600,400);
		break;
		default:
		alert("Error.");
		break;
	}
}
function drawComparedCanvas(canvas,data,names) {
	if(canvasStats[canvas.id]=="evolution" || canvasStats[canvas.id]=="compared") {
		ctx = canvas.getContext("2d");
		var max = new Array();
		for (i = 0; i < canvasGlobalComparedInformations[canvas.id]["data"].length; i++) {
			max.push(Math.max(...canvasGlobalComparedInformations[canvas.id]["data"][i]));
		}
		max = Math.max(...max);
		ctx.beginPath();
		ctx.strokeStyle = colors[canvasGlobalComparedInformations[canvas.id]["data"].length - 1];
		ctx.moveTo(1 * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / max * data[0]));
		ctx.fillStyle = colors[canvasGlobalComparedInformations[canvas.id]["data"].length - 1];
		ctx.fillRect(1 * (canvas.width / (names.length + 1)) - 5,(canvas.height - 50) - ((canvas.height - 60) / max * data[0]) - 5,10,10);
		ctx.fillStyle = "black";
		ctx.fillRect(1 * (canvas.width / (names.length + 1)) - 2,(canvas.height - 50) - ((canvas.height - 60) / max * data[0]) - 2,4,4);
		var i;
		for (i = 1; i < data.length; i++) {
			ctx.lineTo((i + 1) * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / max * data[i]));
			ctx.fillStyle = colors[canvasGlobalComparedInformations[canvas.id]["data"].length - 1];
			ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 5,(canvas.height - 50) - ((canvas.height - 60) / max * data[i]) - 5,10,10);
			ctx.fillStyle = "black";
			ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 2,(canvas.height - 50) - ((canvas.height - 60) / max * data[i]) - 2,4,4);
		}
		ctx.stroke();
		canvasStats[canvas.id] = "compared";
	}
	else {
		alert("Diese Funktion wird derzeit nur von Graphen im Modus \"Entwicklungskurve\" unterstützt.");
	}
}
function compareData(map,canvas,data,names,comparetype,comparereference,compareback) {
	registerCanvasComparedData(canvas.id,names,data);
	data = [data];
	names = [names];
	if(map[1][0]===true) {
			xhr = new XMLHttpRequest();
		xhr.open("GET","getjson.php?context=" + comparetype + "timeline&back=" + (compareback - 1) + "&data=users&reference=" + map[1][1]);
		xhr.responseType = "json";
		xhr.addEventListener("load",function() {
			var json = this.response;
			pushCanvasGlobalComparedData((comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)),(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),canvas);
			drawComparedCanvas(canvas,(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),(comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)));
		});
		xhr.send();
		delete xhr;
	}
	if(map[0][0]===true) {
		xhr = new XMLHttpRequest();
		xhr.open("GET","getjson.php?context=" + comparetype + "timeline&back=" + (compareback - 1) + "&data=calls&reference=" + map[0][1]);
		xhr.responseType = "json";
		xhr.addEventListener("load",function() {
			json = xhr.response;
			pushCanvasGlobalComparedData((comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)),(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),canvas);
			drawComparedCanvas(canvas,(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),(comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)));
		});
		xhr.send();
	}
	if(map[2][0]===true) {
		xhr = new XMLHttpRequest();
		xhr.open("GET","getjson.php?context=" + comparetype + "timeline&back=" + (compareback - 1) + "&data=used_time&reference=" + map[0][1]);
		xhr.responseType = "json";
		xhr.addEventListener("load",function() {
			json = xhr.response;
			pushCanvasGlobalComparedData((comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)),(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),canvas);
			drawComparedCanvas(canvas,(comparetype=="day" ? Object.values(json).reverse() : Object.values(json)),(comparetype=="day" ? Object.keys(json).reverse() : Object.keys(json)));
		});
		xhr.send();
	}
}
canvasGlobalComparedInformations = {};
function pushCanvasGlobalComparedData(names,data,id) {
	canvasGlobalComparedInformations[id.id]["names"].push(names);
	canvasGlobalComparedInformations[id.id]["data"].push(data);
}
function registerCanvasComparedData(id,names,data) {
	if(typeof(canvasGlobalComparedInformations[id])=="undefined") canvasGlobalComparedInformations[id] = {"names":[names],"data":[data]};
}
var graphchangerexecuted = {};
function graphChanger(canvas,data,names,preselected,comparetype,comparereference,compareback) {
	if(typeof(comparetype)=="undefined") {
		comparetype = "nocompare";
		comparereference = "nocompare";
		compareback = "nocompare";
	}
	if(typeof(canvasStats[canvas.id])=="undefined") {
		canvasStats[canvas.id] = preselected;
		canvas.parentElement.appendChild(document.createElement("br"));
		var span = canvas.parentElement.insertBefore(document.createElement("div"),canvas.nextSibling);
		span.id = canvas.id + "_div_element";
		var exportSelect = span.appendChild(document.createElement("select"));
		exportSelect.innerHTML = "<optgroup label='Voreinstellung'><option value='nochange'>Exportieren</option></optgroup><optgroup label='Graphisch'><option value='act'>Aktuelle Darstellung</option><option value='piechart'>Kuchendiagramm</option><option value='barchart'>Säulendiagramm</option><option value='evolution'>Entwicklungskurve</option><option value='evolution+base'>Entwicklungskurve mit Basis</option></optgroup><optgroup label='Tabellen'><option value='csv'>CSV</option><option value='tsv'>TSV (für Excel)</option><option value='html'>HTML</option></optgroup><optgroup label='Andere'><option value='json'>JSON</option></optgroup>";
		var select = span.appendChild(document.createElement("select"));
		select.innerHTML = "<optgroup label='Voreinstellung'><option value='nochange'>Darstellung ändern</option></optgroup><optgroup label='Diagramme'><option value='piechart'>Kuchendiagramm</option><option value='barchart'>Säulendiagramm</option><option value='evolution'>Entwicklungskurve</option><option value='evolution+base'>Entwicklungskurve mit Basis</option></optgroup><optgroup label='Andere Darstellungen'><option value='table'>Tabelle</option></optgroup>";
		select.addEventListener("change",changeGraph.bind(this,canvas,select,data,names));
		exportSelect.addEventListener("change",exportGraph.bind(this,canvas,exportSelect,data,names));
	}
	if(comparetype!="nocompare" && typeof(graphchangerexecuted[canvas.id])=="undefined") {
		canvas.parentElement.insertBefore(document.createElement("span"),canvas.parentElement.childNodes[0]).innerHTML = "Diese Daten ";
		var compromiseSelect = canvas.parentElement.insertBefore(document.createElement("input"),canvas.parentElement.childNodes[1]);
		compromiseSelect.type = "button";
		compromiseSelect.value = "Vergleichen mit";
		compromiseSelect.addEventListener("click",function() {
			var formattedReference = comparereference.split(".").reverse().join("-");
			var selectTime = (comparetype=="day" ? "zurück ab <input type='date' value='" + formattedReference  + "' style='font-family:Arial'>" : "") + (comparetype=="month" ? " in <input type='number' value='" + formattedReference.substr(0,4) + "'>" : "") + (comparetype=="year" ? " zurück ab <input type='number' value='" + formattedReference.substr(0,4) + "'>" : "");
			popup("<h1>Diese Daten vergleichen</h1>Wählen Sie Daten um Sie mit den bisher angezeigten zu vergleichen.<form class='hiddentable'><input type='checkbox' id='0'> <label for='0'>Aufrufe " + selectTime + "</label><br><input type='checkbox' id='1'> <label for='1'>Besucher " + selectTime + "</label><br><input type='checkbox' id='2'> <label for='2'>Durchschnittliche Nutzungszeit " + selectTime + "</label><br><input type='checkbox' style='visibility:hidden'><br><a id='reset_canvas' href='javascript:;'>Zurücksetzen</a> - <i>Bisher bereits im Graphen dargestellte Informationen werden beibehalten, auch sofern sie nicht erneut gewählt werden.</i></form>",screen.width / 2 - 250,screen.height / 2 - 200 ,500,400);
			document.getElementById("reset_canvas").addEventListener("click",function() {
				canvasStats[canvas.id] = "evolution";
				evolution(canvas,data,names);
				canvasGlobalComparedInformations[canvas.id] = {"names":[names],"data":[data]};
				close_popup();
			});
			document.getElementById("popup").style.padding = "20px";
			var compareButton = document.getElementById("popup").childNodes[1].appendChild(document.createElement("button"));
			compareButton.innerHTML = "Vergleichen";
			compareButton.addEventListener("click",function() {
				var inputs = document.getElementById("popup").getElementsByTagName("input");
				var checked = new Array();
				var i;
				for (i = 0; i < inputs.length; i++) {
					if(inputs[i].type=="checkbox") {
						checked.push([inputs[i].checked]);
					}
					else {
						checked[checked.length - 1].push(inputs[i].value);
					}
				}
				compareData(checked,canvas,data,names,comparetype,comparereference,compareback);
				close_popup();
			});
			document.getElementById("popup").childNodes[1].appendChild(compareButton);
		});
		}
		graphchangerexecuted[canvas.id] = true;
}
var lx = ly = 0;
function hoverInformation(canvas,names,data,none,e) {
	if(Math.max(lx - e.pageX,e.pageX - lx) > 5 || Math.max(ly - e.pageY,e.pageY - ly) > 5) {
		lx = e.pageX; ly = e.pageY;
		if(!document.getElementById("hoverInformation")) {
			var hoverInformationElement = document.createElement("div");
			hoverInformationElement = document.body.appendChild(hoverInformationElement);
			hoverInformationElement.style.width = "200px";
			hoverInformationElement.style.border = "1px solid black";
			hoverInformationElement.style.borderRadius = "4px";
			hoverInformationElement.style.padding = "10px";
			hoverInformationElement.style.backgroundColor = "rgba(0,0,0,0.9)";
			hoverInformationElement.style.color = "white";
			hoverInformationElement.height = "300px";
			hoverInformationElement.overflow = "auto";
			hoverInformationElement.id = "hoverInformation";
			hoverInformationElement.style.position = "absolute";
		}
		else {
			var hoverInformationElement = document.getElementById("hoverInformation");
		}
		hoverInformationElement.style.left = parseFloat(e.pageX + 20) + "px";
		hoverInformationElement.style.top = parseFloat(e.pageY - 5) + "px";
		if(hoverInformationElement.innerHTML=="") {
			if(typeof(canvasGlobalComparedInformations[canvas.id])=="undefined") {
				var i;
				for (i = 0; i < names.length; i++) {
					hoverInformationElement.innerHTML += "<span style='color:" + colors[i] + "'>&#8718; " + names[i] + ": " + data[i] + "</span><br>";
				}
			}
			if(typeof(canvasGlobalComparedInformations[canvas.id])!="undefined") {
				var i;
				for (i = 0; i < canvasGlobalComparedInformations[canvas.id]["names"].length; i++) {
					hoverInformationElement.innerHTML += "<div style='color:" + colors[i] + "'>&#8718; " + (i + 1) + ". Daten<div>";
					for(index = 0; index < canvasGlobalComparedInformations[canvas.id]["names"][i].length; index++) {
						hoverInformationElement.innerHTML += "<div style='color:" + colors[index] + ";font-size:8pt;margin-left:10px;text-align:left'>" + canvasGlobalComparedInformations[canvas.id]["names"][i][index] + ": " + canvasGlobalComparedInformations[canvas.id]["data"][i][index] + "</div>";
					}
					hoverInformationElement.innerHTML += "</div></div>";
				}
			}
		}
	}
	return true;
}
function stopHoverInformation() {
	document.getElementById("hoverInformation").parentNode.removeChild(document.getElementById("hoverInformation"));
	if(document.getElementById("extendedHoverInformation")) document.getElementById("extendedHoverInformation").parentNode.removeChild(document.getElementById("extendedHoverInformation"));
}
var lxextended = lyextended = 0;
function extendedInfo(canvas,names,data,none,e) {
	var left = e.pageX - canvas.offsetLeft;
	var pixelTop = e.pageY - canvas.offsetTop;
	if(canvasStats[canvas.id]!="piechart" && Math.max(left - lxextended, lxextended - left) > 5 || Math.max(pixelTop - lyextended,lyextended - pixelTop) > 5) {
	lx = left; ly = pixelTop;
	var width = (canvas.style.width.toString().indexOf("%")===-1 ? (canvas.style.width!="" ? canvas.style.width.replace("px","") : canvas.width) : (canvas.style.width.toString().replace("%","") / 100) * canvas.parentElement.offsetWidth);
	for(i = 0; i < data.length; i++) {
		min = (i + 1) * (width / (names.length + 1)) - 25;
		max = (i + 1) * (width / (names.length + 1)) + 25;
		if(left <= max && left >= min) {
			if(!document.getElementById("extendedHoverInformation")) elem = document.body.appendChild(document.createElement("div"));
			else elem = document.getElementById("extendedHoverInformation");
			if(canvasStats[canvas.id]!="compared") elem.innerHTML = "Sie sehen<br><span style='color:" + colors[i] + "'>" + names[i] + ": " + data[i] + "</span>";
			else {
				var names = canvasGlobalComparedInformations[canvas.id]["names"];
				var data = canvasGlobalComparedInformations[canvas.id]["data"];
				elem.innerHTML = "Sie sehen<br>";
				for(index = 0; index < data.length; index++) {
					elem.innerHTML += "<span style='color:" + colors[index] + "'>" + names[index][i] + ": " + data[index][i] + "</span><br>";
				}
			}
			elem.id = "extendedHoverInformation";
			elem.style.position = "absolute";
			elem.style.left = parseFloat(e.pageX - 130) + "px";
			elem.style.top = parseFloat(e.pageY - 5) + "px";
			elem.style.backgroundColor = "rgba(0,0,0,0.7)";
			elem.style.borderRadius = "4px";
			elem.style.padding = "10px";
			elem.style.color = "white";
			elem.style.width = "100px";
			if(canvasStats[canvas.id]=="evolution" || canvasStats[canvas.id]=="evolution+base") {
				var ctx = canvas.getContext("2d");
				ctx.fillStyle = "rgba(0,0,0,0.1)";
				setShadow("no-shadow",ctx);
				ctx.beginPath();
				ctx.arc((i + 1) * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]),6,0,2*Math.PI);
				ctx.fill();
			}
			else if(canvasStats[canvas.id]=="barchart") {
				var ctx = canvas.getContext("2d");
				ctx.fillStyle = "rgba(0,0,0,0.05)";
				setShadow("no-shadow",ctx);
				ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 25,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) - 1,50,1);
				ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 25,canvas.height - 50,50,1);
				ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 25,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]),1,((canvas.height - 60) / Math.max(...data) * data[i]));
				ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) + 25,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]),1,((canvas.height - 60) / Math.max(...data) * data[i]));
			}
			break;
		} else if(document.getElementById("extendedHoverInformation")) document.getElementById("extendedHoverInformation").parentNode.removeChild(document.getElementById("extendedHoverInformation"));
	}
	} else if(canvasStats[canvas.id]=="piechart") {
		let imagedata = canvas.getContext("2d").getImageData(0, 0, canvas.width, canvas.height);
		let width = imagedata.width;
		imagedata = imagedata.data;
		let pixelbegin = pixelTop * (width * 4) + (left * 4);
		let hexa = rgbToHexa(imagedata[pixelbegin],imagedata[pixelbegin + 1],imagedata[pixelbegin + 2]);
		if(hexa!="#000") {
			if(!document.getElementById("extendedHoverInformation")) elem = document.body.appendChild(document.createElement("div"));
			else elem = document.getElementById("extendedHoverInformation");
			elem.innerHTML = "<span style='color:" + hexa + "'>" + names[colors.indexOf(hexa)] + " " + Math.round(data[colors.indexOf(hexa)]) + "%</span>";
			elem.id = "extendedHoverInformation";
			elem.style.position = "absolute";
			elem.style.left = parseFloat(e.pageX - 130) + "px";
			elem.style.top = parseFloat(e.pageY - 5) + "px";
			elem.style.backgroundColor = "rgba(0,0,0,0.7)";
			elem.style.borderRadius = "4px";
			elem.style.padding = "10px";
			elem.style.color = "white";
			elem.style.width = "100px";
			} else if(document.getElementById("extendedHoverInformation")) document.getElementById("extendedHoverInformation").parentNode.removeChild(document.getElementById("extendedHoverInformation"));
	}
}
function barchartInfo(canvas,names,data) {
if(canvasStats[canvas.id]=="barchart" || canvasStats[canvas.id]=="evolution" || canvasStats[canvas.id]=="evolution+base" || typeof(canvasStats[canvas.id])=="undefined") {
var ctx = canvas.getContext("2d");
ctx.fillStyle = "black";
var i;
for (i = 0; i < data.length; i++) { 
if((canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) < 240) ctx.fillText(data[i],(i + 1) * (canvas.width / (names.length + 1)) - (data[i].toString().length * 8 / 2),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) + 30);
else ctx.fillText(data[i],(i + 1) * (canvas.width / (names.length + 1)) - (data[i].toString().length * 8 / 2),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) - 10);
}
canvas.addEventListener("mousemove",extendedInfo.bind(this,canvas,names,data,canvas.event));
canvas.addEventListener("mousemove",hoverInformation.bind(this,canvas,names,data,canvas.event));
canvas.addEventListener("mouseleave",stopHoverInformation);
return true;
}
}
function canvasNoDataWarning(canvas,data) {
	if(data==null || data.length==0) {
		window.addEventListener("load",function() {
			message("Für manche Berichte auf dieser Seite stehen keine Daten zur Verfügung. <a href='javascript:close_message()'>Schliessen</a>",5000);
		});
		var ctx = canvas.getContext("2d");
		ctx.font = "20px Arial";
		ctx.fillStyle = "grey";
		ctx.fillText("Keine Daten für diesen Begriff verfügbar",canvas.width / 2 - 20,canvas.height / 2 - 10);
	}
}
var barchartexecuted = {};
function barchart(canvas,data,names,comparetype,comparereference,compareback) {
	canvasNoDataWarning(canvas,data);
	if(canvasStats[canvas.id]=="barchart" || typeof(canvasStats[canvas.id])=="undefined") {
		var ctx = canvas.getContext("2d");
		setShadow("no-shadow",ctx);
		ctx.clearRect(0,0,canvas.width,canvas.height);
		graphBackground(canvas,data,names);
		setShadow("shadow",ctx,false);
		var i;
		for (i = 0; i < data.length; i++) {
		ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 25,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]),50,(canvas.height - 60) / Math.max(...data) * data[i]);
		}
		if(typeof(barchartexecuted[canvas.id])=="undefined") {
			canvas.addEventListener("mouseenter",barchartInfo.bind(this,canvas,names,data));
			canvas.addEventListener("mouseleave",barchart.bind(this,canvas,data,names));
		}
		barchartexecuted[canvas.id] = true;
		graphChanger(canvas,data,names,"barchart",comparetype,comparereference,compareback);
		return true;
	}
}
function piechart(canvas,data,names) {
	canvasNoDataWarning(canvas,data);
	var ctx = canvas.getContext("2d");
	ctx.clearRect(0,0,canvas.width,canvas.height);
	var percents = arrayPercent(data);
    var bisher = 1.5;
    var i;
    for (i = 0; i < percents.length; i++) {
		setShadow("light-shadow",ctx);
		ctx.fillStyle = colors[i];
		ctx.beginPath();
		ctx.moveTo(150,150);
		ctx.arc(150,150,140,bisher*Math.PI,(2/100*percents[i])*Math.PI+bisher*Math.PI);
		bisher = bisher + 2/100*percents[i];
		ctx.lineTo(150,150);
		ctx.fill();
		ctx.font = "15px Arial";
		ctx.fillText(names[i],320,i*20+145-(percents.length * 10));
		ctx.fillRect(305,i*20+135-(percents.length * 10),10,10);
	}
	canvas.addEventListener("mousemove",hoverInformation.bind(this,canvas,names,data,canvas.event));
	canvas.addEventListener("mousemove",extendedInfo.bind(this,canvas,names,data,canvas.event));
	canvas.addEventListener("mouseenter",hoverInformation.bind(this,names,data,canvas.event));
	canvas.addEventListener("mouseleave",stopHoverInformation);
	graphChanger(canvas,data,names,"piechart");
}
var evolutionExecuted = {};
function evolution(canvas,data,names,base) {
	canvasNoDataWarning(canvas,data);
	if(typeof(base)=="undefined" || base===false) base = false;
	if(canvasStats[canvas.id]=="evolution" || canvasStats[canvas.id]=="evolution+base" || typeof(canvasStats[canvas.id])=="undefined") {
		var ctx = canvas.getContext("2d");
		ctx.fillStyle = "black";
		ctx.strokeStyle = "black";
		ctx.clearRect(0,0,canvas.width,canvas.height);
		graphBackground(canvas,data,names);
		setShadow("shadow",ctx);
		ctx.beginPath();
		ctx.moveTo(1 * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[0]));
		ctx.fillStyle = "grey";
		ctx.fillRect(1 * (canvas.width / (names.length + 1)) - 5,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[0]) - 5,10,10);
		ctx.fillStyle = "black";
		ctx.fillRect(1 * (canvas.width / (names.length + 1)) - 2,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[0]) - 2,4,4);
		var i;
		for (i = 1; i < data.length; i++) {
			ctx.lineTo((i + 1) * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]));
			ctx.fillStyle = "grey";
			ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 5,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) - 5,10,10);
			ctx.fillStyle = "black";
			ctx.fillRect((i + 1) * (canvas.width / (names.length + 1)) - 2,(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[i]) - 2,4,4);
		}
		if(base==true && canvasStats[canvas.id]=="evolution+base" || typeof(canvasStats[canvas.id])=="undefined") {
			ctx.lineTo(data.length * (canvas.width / (names.length + 1)),canvas.height - 50);
			ctx.lineTo(1 * (canvas.width / (names.length + 1)),canvas.height - 50);
			ctx.lineTo(1 * (canvas.width / (names.length + 1)),(canvas.height - 50) - ((canvas.height - 60) / Math.max(...data) * data[0]));
			var gradient = ctx.createLinearGradient(0,0,0,canvas.height);
			gradient.addColorStop(0,"rgba(0,0,0,0.5)");
			gradient.addColorStop(1,"white");
			ctx.fillStyle = gradient;
			ctx.fill();
			ctx.fillStyle = "rgba(255,255,255,0.5)";
		} else ctx.stroke();
		if(typeof(evolutionExecuted[canvas.id])=="undefined") {
			canvas.addEventListener("mouseenter",barchartInfo.bind(this,canvas,names,data));
			canvas.addEventListener("mouseleave",evolution.bind(this,canvas,data,names,(base===true ? true : false)));
		}
		evolutionExecuted[canvas.id] = true;
	}
} 
function search_option(elem,attribute,is) {
	var i;
	for (i = 0; i < elem.options.length; i++) {
		if(elem.options[i].getAttribute(attribute)==is) return i;
	}
}
function loadDoubleTableAsJSON(t,loadThead) {
	if(typeof(loadThead)=="undefined") loadThead = false;
	var rows = t.getElementsByTagName("tr");
	var json = {};
	for (i = 0; i < rows.length; i++) {
		if(rows[i].parentElement.tagName!="THEAD" || loadThead==true) {
			var cells = rows[i].getElementsByTagName("td");
			json[cells[0].innerHTML] = cells[1].innerHTML;
		}
	}
	return json;
}