<?php header("Content-Type: image/svg+xml");
if(!file_get_contents('log.txt')) {
	chmod('../log.txt',0777);
	register_shutdown_function('chmod','../log.txt',0000);
}
$file = file('../log.txt');
foreach($file AS $call) {
$call = explode(', ',$call);
$geolocation[] = $call[14];
}

?>
<svg id="img" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg" height="649.0" viewBox="0 0 1280.0 649.0" width="1280.0" version="1.1" xmlns:cc="http://creativecommons.org/ns#" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/">
<g>
<image xlink:href="world-map.png" transform="matrix(1.0, 0.0, 0.0, 1.0, 0.0, 649.0)" height="649.0" width="1280.0" y="-649.0" x="0" />
</g>
<rect style="fill:#EBECED;" x="70" y="315" width="200" height="230"/>
<text x="105" y="335" class="percents">&lt; 10 %</text>
<text x="105" y="360" class="percents">&lt; 20 %</text>
<text x="105" y="385" class="percents">&lt; 30 %</text>
<text x="105" y="410" class="percents">&lt; 40 %</text>
<text x="105" y="435" class="percents">&lt; 50 %</text>
<text x="105" y="460" class="percents">&lt; 60 %</text>
<text x="105" y="485" class="percents">&lt; 70 %</text>
<text x="105" y="510" class="percents">&lt; 80 %</text>
<text x="105" y="535" class="percents">&lt; 90 %</text>
<rect id="ten" x="80" y="320" width="20" height="20"/>
<rect id="twenty" x="80" y="345" width="20" height="20"/>
<rect id="thirty" x="80" y="370" width="20" height="20"/>
<rect id="forty" x="80" y="395" width="20" height="20"/>
<rect id="fifty" x="80" y="420" width="20" height="20"/>
<rect id="sixty" x="80" y="445" width="20" height="20"/>
<rect id="seventy" x="80" y="470" width="20" height="20"/>
<rect id="eighty" x="80" y="495" width="20" height="20"/>
<rect id="ninety" x="80" y="520" width="20" height="20"/>
<circle id="Canada" cx="280" cy="100" r="10"/>
<circle id="United States" cx="270" cy="165" r="10"/>
<circle id="Mexico" cx="250" cy="225" r="8"/>
<circle id="Guatemala" cx="285" cy="262" r="4"/>
<circle id="Belize" cx="295" cy="256" r="4"/>
<circle id="El Salvador" cx="290" cy="271" r="4"/>
<circle id="Honduras" cx="298" cy="265" r="4"/>
<circle id="Nicaragua" cx="305" cy="272" r="4"/>
<circle id="Costa Rica" cx="308" cy="285" r="3"/>
<circle id="Panama" cx="318" cy="290" r="3"/>
<circle id="Colombia" cx="345" cy="305" r="6"/>
<circle id="Venezuela" cx="372" cy="295" r="6"/>
<circle id="Ecuador" cx="325" cy="330" r="6"/>
<circle id="Peru" cx="337" cy="365" r="6"/>
<circle id="Brazil" cx="415" cy="360" r="8"/>
<circle id="Guyana" cx="395" cy="305" r="4"/>
<circle id="Suriname" cx="405" cy="308" r="4"/>
<circle id="French Guiana" cx="415" cy="310" r="4"/>
<circle id="Bolivia" cx="378" cy="390" r="6"/>
<circle id="Chile" cx="365" cy="440" r="4"/>
<circle id="Paraguay" cx="402" cy="420" r="6"/>
<circle id="Argentina" cx="390" cy="460" r="8"/>
<!--<circle id="Falkland Islands" cx="430" cy="532" r="2"/>-->
<circle id="Portugal" cx="580" cy="165" r="4"/>
<circle id="Spain" cx="595" cy="165" r="4"/>
<circle id="France" cx="615" cy="140" r="4"/>
<circle id="United Kingdom" cx="604" cy="110" r="4"/>
<circle id="Switzerland" cx="634" cy="136" r="3"/>
<circle id="Ireland" cx="585" cy="112" r="3"/>
<!--<circle id="Northern Ireland" cx="588" cy="107" r="3"/>-->
<circle id="Belgium" cx="621" cy="122" r="2"/>
<circle id="Netherlands" cx="627" cy="118" r="2"/>
<circle id="Italy" cx="651" cy="155" r="3"/>
<circle id="Germany" cx="640" cy="120" r="4"/>
<circle id="Poland" cx="665" cy="115" r="4"/>
<circle id="Czech Republic" cx="656" cy="125" r="4"/>
<circle id="Austria" cx="652" cy="134" r="3"/>
<circle id="Slovenia" cx="656" cy="138" r="2"/>
<circle id="Croatia" cx="660" cy="142" r="2"/>
<circle id="Bosnia And Herzegovina" cx="665" cy="147" r="2"/>
<circle id="Montenegro" cx="670" cy="152" r="2"/>
<circle id="Albania" cx="672" cy="158" r="2"/>
<circle id="Greece" cx="679" cy="165" r="3"/>
<circle id="Kosovo" cx="678" cy="157" r="2"/>
<circle id="Serbia" cx="675" cy="148" r="3"/>
<circle id="Hungary" cx="668" cy="136" r="3"/>
<circle id="Slovakia" cx="670" cy="129" r="2"/>
<circle id="Romania" cx="686" cy="140" r="4"/>
<circle id="Bulgaria" cx="688" cy="153" r="3"/>
<circle id="Moldova" cx="697" cy="135" r="3"/>
<circle id="Norway" cx="639" cy="81" r="5"/>
<circle id="Sweden" cx="654" cy="81" r="5"/>
<circle id="Finland" cx="685" cy="75" r="5"/>
<circle id="Russian Federation" cx="900" cy="80" r="10"/>
<circle id="Norway" cx="639" cy="81" r="5"/>
<circle id="Estonia" cx="685" cy="91" r="2"/>
<circle id="Latvia" cx="684" cy="97" r="2"/>
<circle id="Lithuania" cx="682" cy="103" r="3"/>
<circle id="Belarus" cx="694" cy="110" r="5"/>
<circle id="Ukraine" cx="700" cy="125" r="5"/>
<circle id="Turkey" cx="720" cy="166" r="5"/>
<circle id="Georgia" cx="748" cy="154" r="2"/>
<circle id="Armenia" cx="753" cy="162" r="2"/>
<circle id="Azerbaijan" cx="763" cy="162" r="2"/>
<circle id="Syrian Arab Republic" cx="734" cy="185" r="4"/>
<circle id="Israel" cx="726" cy="192" r="2"/>
<circle id="Jordan" cx="731" cy="198" r="2"/>
<circle id="Iraq" cx="751" cy="190" r="6"/>
<circle id="Iran, Islamic Republic Of" cx="789" cy="193" r="7"/>
<circle id="Saudi Arabia" cx="760" cy="230" r="6"/>
<circle id="Yemen" cx="772" cy="261" r="5"/>
<circle id="Oman" cx="795" cy="250" r="4"/>
<circle id="United Arab Emirates" cx="795" cy="229" r="4"/>
<circle id="Turkmenistan" cx="798" cy="164" r="6"/>
<circle id="Afghanistan" cx="826" cy="190" r="6"/>
<circle id="Pakistan" cx="838" cy="210" r="6"/>
<circle id="India" cx="878" cy="230" r="9"/>
<circle id="Uzbekistan" cx="815" cy="157" r="4"/>
<circle id="Kazakhstan" cx="820" cy="130" r="8"/>
<circle id="Tajikistan" cx="840" cy="168" r="2"/>
<circle id="Kyrgyzstan" cx="850" cy="157" r="3"/>
<circle id="China" cx="925" cy="184" r="10"/>
<circle id="Mongolia" cx="930" cy="137" r="8"/>
<circle id="Nepal" cx="895" cy="212" r="3"/>
<circle id="Bhutan" cx="915" cy="215" r="3"/>
<circle id="Bangladesh" cx="917" cy="226" r="3"/>
<circle id="Myanmar" cx="940" cy="238" r="5"/>
<circle id="Thailand" cx="960" cy="260" r="5"/>
<circle id="Laos" cx="964" cy="245" r="4"/>
<circle id="Cambodia" cx="975" cy="273" r="4"/>
<circle id="Vietnam" cx="987" cy="272" r="3"/>
<circle id="North Korea" cx="1023" cy="163" r="4"/>
<circle id="South Korea" cx="1033" cy="178" r="4"/>
<circle id="Japan" cx="1069" cy="178" r="4"/>
<circle id="Taiwan" cx="1025" cy="230" r="3"/>
<circle id="Philippines" cx="1040" cy="280" r="5"/>
<circle id="Malaysia" cx="1006" cy="315" r="4"/>
<circle id="Indonesia" cx="1010" cy="328" r="5"/>
<!--<circle id="East Timor" cx="1047" cy="362" r="3"/>-->
<circle id="Maldives" cx="860" cy="300" r="4"/>
<circle id="Sri Lanka" cx="891" cy="294" r="4"/>
<circle id="Morocco" cx="580" cy="200" r="5"/>
<circle id="Algeria" cx="612" cy="210" r="9"/>
<circle id="Tunisia" cx="638" cy="190" r="4"/>
<circle id="Libya" cx="665" cy="215" r="7"/>
<circle id="Egypt" cx="705" cy="217" r="7"/>
<circle id="Western Sahara" cx="560" cy="222" r="4"/>
<circle id="Mauritania" cx="570" cy="245" r="7"/>
<circle id="Mali" cx="600" cy="250" r="7"/>
<circle id="Niger" cx="640" cy="255" r="8"/>
<circle id="Chad" cx="672" cy="255" r="7"/>
<circle id="Sudan" cx="710" cy="265" r="9"/>
<circle id="Senegal" cx="555" cy="263" r="5"/>
<circle id="Gambia" cx="552" cy="271" r="2"/>
<circle id="Guinea-Bissau" cx="552" cy="275" r="2"/>
<circle id="Guinea" cx="565" cy="280" r="4"/>
<circle id="Sierra Leone" cx="562" cy="290" r="3"/>
<circle id="Liberia" cx="570" cy="296" r="3"/>
<circle id="Cote D'Ivoire" cx="585" cy="293" r="5"/>
<circle id="Ghana" cx="600" cy="293" r="5"/>
<circle id="Burkina Faso" cx="600" cy="274" r="5"/>
<circle id="Togo" cx="607" cy="288" r="2"/>
<circle id="Benin" cx="613" cy="285" r="3"/>
<circle id="Nigeria" cx="632" cy="286" r="7"/>
<circle id="Cameroon" cx="647" cy="304" r="5"/>
<circle id="Central African Republic" cx="678" cy="297" r="5"/>
<circle id="South Sudan" cx="710" cy="295" r="5"/>
<circle id="Ethiopia" cx="745" cy="290" r="5"/>
<circle id="Eritrea" cx="740" cy="260" r="3"/>
<circle id="Djibouti" cx="755" cy="278" r="2"/>
<circle id="Somalia" cx="775" cy="295" r="5"/>
<circle id="Kenya" cx="738" cy="322" r="5"/>
<circle id="Uganda" cx="720" cy="318" r="5"/>
<circle id="Congo, Democratic Republic" cx="690" cy="335" r="8"/>
<circle id="Congo" cx="660" cy="325" r="5"/>
<circle id="Gabon" cx="649" cy="325" r="5"/>
<circle id="Equatorial Guinea" cx="642" cy="318" r="3"/>
<circle id="Angola" cx="665" cy="373" r="7"/>
<circle id="Zambia" cx="698" cy="384" r="7"/>
<circle id="Rwanda" cx="710" cy="333" r="2"/>
<circle id="Burundi" cx="711" cy="338" r="2"/>
<circle id="Tanzania" cx="728" cy="350" r="7"/>
<circle id="Malawi" cx="725" cy="382" r="2"/>
<circle id="Mozambique" cx="739" cy="382" r="5"/>
<circle id="Namibia" cx="664" cy="410" r="6"/>
<circle id="Botswana" cx="689" cy="412" r="6"/>
<circle id="Zimbabwe" cx="710" cy="400" r="6"/>
<circle id="South Africa" cx="685" cy="445" r="6"/>
<circle id="Lesotho" cx="703" cy="444" r="3"/>
<circle id="Swaziland" cx="714.5" cy="432" r="2"/>
<circle id="Madagascar" cx="767" cy="406" r="6"/>
<circle id="Indonesia" cx="1095" cy="340" r="5"/>
<circle id="Papua New Guinea" cx="1113" cy="348" r="4"/>
<circle id="Australia" cx="1070" cy="422" r="10"/>
<circle id="New Zealand" cx="1162" cy="496" r="4"/>
<circle id="Solomon Islands" cx="1165" cy="358" r="4"/>
<circle id="Vanuatu" cx="1192" cy="390" r="3"/>
<circle id="Fiji" cx="1230" cy="395" r="2"/>
<circle id="Tonga" cx="1240" cy="404" r="2"/>
<circle id="Samoa" cx="1250" cy="390" r="2"/>
<circle id="Kiribati" cx="1210" cy="315" r="2"/>
<circle id="Marshall Islands" cx="1203" cy="305" r="2"/>
<circle id="Micronesia, Federated States Of" cx="1140" cy="297" r="2"/>
<circle id="Nauru" cx="1190" cy="310" r="2"/>
<circle id="Palau" cx="1088" cy="300" r="2"/>

<!-- Flag Graphic -->
<image style="opacity:0.5" x="650" y="550" xlink:href="flag-example.png" height="100" width="100" id="flag_show"/>

<!-- Section Zoom -->
<rect x="1200" y="30" width="35" height="35" onclick="zoomin();" fill="white" stroke-width="2" stroke="grey" class="zoom"/>
<text x="1209" y="57" class="zoomtext" onclick="zoomin()">+</text>
<rect x="1200" y="80" width="35" height="35" onclick="zoomout();" fill="white" stroke-width="2" stroke="grey" class="zoom"/>
<text x="1213" y="105" class="zoomtext" onclick="zoomout()">-</text>

<!-- Section scroll -->
<rect x="1200" y="520" class="scroll" onclick="scrollimgTop()" width="35" height="35"  fill="white" stroke-width="2" stroke="grey"/>
<text x="1210" y="542" class="scrolltext" onclick="scrollimgTop()">&#8593;</text>

<rect x="1165" y="555" class="scroll" onclick="scrollimgLeft()" width="35" height="35"  fill="white" stroke-width="2" stroke="grey"/>
<text x="1170" y="579" class="scrolltext" onclick="scrollimgLeft()">&#8592;</text>

<rect x="1235" y="555" class="scroll" onclick="scrollimgRight()" width="35" height="35"  fill="white" stroke-width="2" stroke="grey"/>
<text x="1239" y="579" class="scrolltext" onclick="scrollimgRight()">&#8594;</text>

<rect x="1200" y="590" class="scroll" onclick="scrollimgBottom()" width="35" height="35"  fill="white" stroke-width="2" stroke="grey"/>
<text x="1210" y="612" class="scrolltext" onclick="scrollimgBottom()">&#8595;</text>

<text x="450" y="510" id="country">Besucherkarte</text>
<text x="450" y="540" id="hits">Über einen Punkt fahren, um mehr anzuzeigen</text>
<script>
<![CDATA[
var users = <?php echo json_encode(array_count_values($geolocation)) ?>; var sum = <?php echo count($file) ?>;
var circles = document.getElementsByTagName("circle");
var executed = false;
function draw() {
var i;
for (i = 0; i < circles.length; i++) {
circles[i].addEventListener("mouseover",show_info);
circles[i].addEventListener("click",show_popup_info);
if(typeof(users[circles[i].id])=="undefined") {
users[circles[i].id] = 0;
}
circles[i].style.fill = "grey";
if((100 / sum * users[circles[i].id]) > 10) {
circles[i].style.fill = "#C7D1F8";
}
if((100 / sum * users[circles[i].id]) > 20) {
circles[i].style.fill = "#B1BEF8";
}
if((100 / sum * users[circles[i].id]) > 30) {
circles[i].style.fill = "#99AAF6";
}
if((100 / sum * users[circles[i].id]) > 40) {
circles[i].style.fill = "#8C9FEF";
}
if((100 / sum * users[circles[i].id]) > 50) {
circles[i].style.fill = "#6C83E5";
}
if((100 / sum * users[circles[i].id]) > 60) {
circles[i].style.fill = "#566DD9";
}
if((100 / sum * users[circles[i].id]) > 70) {
circles[i].style.fill = "#445ED2";
}
if((100 / sum * users[circles[i].id]) > 80) {
circles[i].style.fill = "#2E4DD3";
}
if((100 / sum * users[circles[i].id]) > 90) {
circles[i].style.fill = "#0B2CC0";
}
if(parent.document.getElementById("map").offsetWidth < 800 && executed==false) {
	circles[i].setAttribute("r",circles[i].getAttribute("r") - (0 - 3));
}
}
executed = true;
}
draw();
var label = "Aufrufe";
function show_info() {
document.getElementById("country").innerHTML = parent.translateCountryName(this.id,"de");
document.getElementById("hits").innerHTML = users[this.id] + " " + label + " | " + Math.round(100 / sum * users[this.id]) + "% aller " + label;
document.getElementById("country").setAttribute("x", (document.getElementById("img").getAttribute("width") / 2 - (parent.translateCountryName(this.id,"de").length * 18 / 2)) / 100 * zoom + scrollX);
document.getElementById("hits").setAttribute("x", (document.getElementById("img").getAttribute("width") / 2 - (parent.translateCountryName(this.id,"de").length * 18 / 2)) / 100 * zoom + scrollX);
document.getElementById("flag_show").setAttribute("xlink:href","flags/redirect.php?country=" + this.id.replace("'","-").toLowerCase());
}
var zoom = 100;
var scrollY = 0;
var scollX = 0;
const zoomers = document.getElementsByClassName("zoom");
const zoomtext = document.getElementsByClassName("zoomtext");
const scrollers = document.getElementsByClassName("scroll");
var scrolltext = document.getElementsByClassName("scrolltext");
function zoomimg() {
document.getElementById("img").setAttribute("viewBox",scrollX + " " + scrollY + " " + 1280 / 100 * zoom + " " + 649 / 100 * zoom);

document.getElementById("country").setAttribute("x",450 / 100 * zoom + scrollX);
document.getElementById("country").setAttribute("y",510 / 100 * zoom + scrollY);
document.getElementById("country").style.fontSize = 35 / 100 * zoom + "pt";
document.getElementById("hits").setAttribute("x",450 / 100 * zoom + scrollX);
document.getElementById("hits").setAttribute("y",540 / 100 * zoom + scrollY);
document.getElementById("hits").style.fontSize = 20 / 100 * zoom + "pt";

// Section Scroll
scrollers[0].setAttribute("x",1200 / 100 * zoom + scrollX);
scrollers[0].setAttribute("y",520 / 100 * zoom + scrollY);
scrolltext[0].setAttribute("x",1210 / 100 * zoom + scrollX);
scrolltext[0].setAttribute("y",542 / 100 * zoom + scrollY);
scrollers[1].setAttribute("x",1165 / 100 * zoom + scrollX);
scrollers[1].setAttribute("y",555 / 100 * zoom + scrollY);
scrolltext[1].setAttribute("x",1170 / 100 * zoom + scrollX);
scrolltext[1].setAttribute("y",579 / 100 * zoom + scrollY);
scrollers[2].setAttribute("x",1235 / 100 * zoom + scrollX);
scrollers[2].setAttribute("y",555 / 100 * zoom + scrollY);
scrolltext[2].setAttribute("x",1239 / 100 * zoom + scrollX);
scrolltext[2].setAttribute("y",579 / 100 * zoom + scrollY);
scrollers[3].setAttribute("x",1200 / 100 * zoom + scrollX);
scrollers[3].setAttribute("y",590 / 100 * zoom + scrollY);
scrolltext[3].setAttribute("x",1210 / 100 * zoom + scrollX);
scrolltext[3].setAttribute("y",612 / 100 * zoom + scrollY);
var i;
for (i = 0; i < 4; i++) { 
if(typeof(zoomers[i])!="undefined") {
zoomers[i].setAttribute("x",1200 / 100 * zoom + scrollX);
zoomers[i].setAttribute("y",30 / 100 * zoom + (i*(50 / 100 *zoom)) + scrollY);
zoomers[i].setAttribute("width",35 / 100 * zoom);
zoomers[i].setAttribute("height",35 / 100 * zoom);
zoomers[i].setAttribute("stroke-width",2 / 100 * zoom);
zoomtext[i].style.fontSize = 28 / 100 * zoom + "px";
}
scrollers[i].setAttribute("width", 35 / 100 * zoom);
scrollers[i].setAttribute("height", 35 / 100 * zoom);
scrollers[i].setAttribute("stroke-width",2 / 100 * zoom);
scrolltext[i].style.fontSize = 28 / 100 * zoom + "px";
if(typeof(zoomtext[i])!="undefined") {
if(i==0) {
zoomtext[i].setAttribute("x",1209 / 100 * zoom + scrollX);
}
else {
zoomtext[i].setAttribute("x",1213 / 100 * zoom + scrollX);
}
zoomtext[i].setAttribute("y",57 / 100 * zoom + (i*(48 / 100 *zoom)) + scrollY);
}
}
console.log("Set zoom Level to " + zoom + "%");
return true;
}
function zoomin() {
if(zoom - 10 > 0) {
var interval = setInterval(function() {zoom = zoom - 1;
zoomimg();},50);
setTimeout(function() { clearInterval(interval) },500);
}
else alert("Der maximale Zoom wurde erreicht.");
}
function zoomout() {
var interval = setInterval(function() {zoom = zoom + 1;
zoomimg();},50);
setTimeout(function() { clearInterval(interval) },500);
}
function scrollimgTop() {
var interval = setInterval(function() {
scrollY = scrollY - 5;
zoomimg();
},50);
setTimeout(function() { clearInterval(interval) },551);
}
function scrollimgBottom() {
var interval = setInterval(function() {
scrollY = scrollY + 5;
zoomimg();
},50);
setTimeout(function() { clearInterval(interval) },551);
}
function scrollimgLeft() {
var interval = setInterval(function() {
scrollX = scrollX - 5;
zoomimg();
},50);
setTimeout(function() { clearInterval(interval) },551);
}
function scrollimgRight() {
var interval = setInterval(function() {
scrollX = scrollX + 5;
zoomimg();
},50);
setTimeout(function() { clearInterval(interval) },551);
}
function showSouthAmerica() {
zoom = 50;
scrollX = 90;
scrollY = 250;
zoomimg();
}
function showNorthAmerica() {
zoom = 40;
scrollX = 30;
scrollY = 20;
zoomimg();
}
function showEurope() {
zoom = 30;
scrollX = 450;
scrollY = 40;
zoomimg();
}
function showAfrica() {
zoom = 50;
scrollX = 380;
scrollY = 160;
zoomimg();
}
function showAsia() {
zoom = 50;
scrollX = 580;
scrollY = -40;
zoomimg();
}
function showAustralia() {
zoom = 40;
scrollX = 800;
scrollY = 300;
zoomimg();
}
if(parent.document.getElementById("map_options")) {
parent.document.getElementById("map_options").addEventListener("change",loadjson);
}
var labelname = {"calls":"Aufrufe","users":"Einzelne Nutzer","advanced":{"ecommerce+products":"Verkaufte Produkte"}};
function loadjson() {
label = this.options[this.selectedIndex].text;
var xhr = new XMLHttpRequest();
xhr.open("GET","../getjson.php?context=map&data=" + this.value);
xhr.responseType = "json";
xhr.addEventListener("load",function() { users = this.response; sum = users["sum"]; draw(); });
xhr.send();
}
function show_popup_info() {
parent.popup("<h1>Landesinformation</h1><img src=\'img/flags/redirect.php?country=" + this.id + "\' style=\'max-width:300px;max-height:200px;float:left;margin-left:20px\'><a href='https://www.openstreetmap.org/search?query=" + this.id + " state' target='_blank'>" + parent.translateCountryName(this.id,"de") + "</a>: " + users[this.id] + "/" + sum + ", dies entspricht " + 100 / sum * users[this.id] + "%<br><br><a href=\'detail.php?view=land&country=" + this.id + "\' title=\'Detaillierte Länderinformationen für " + parent.translateCountryName(this.id,"de") + "\'><canvas id=\'country_timeline\' width=\'390\' height=\'150\'></a>",screen.availWidth / 2 - 400,230,800,300);
canvas = parent.document.getElementById("country_timeline");
var xhr = new XMLHttpRequest();
xhr.open("GET","../getjson.php?context=daytimeline&data=" + (parent.document.getElementById("map_options") ? parent.document.getElementById("map_options").value : "calls") + "&sortedby=country&back=6&country=" + this.id);
xhr.responseType = "json";
xhr.addEventListener("load",function() { days = this.response; draw_timeline(); });
xhr.send();
function draw_timeline() {
ctx = canvas.getContext("2d");
ctx.fillRect(0,120,1000,1);
ctx.font = "6pt Arial";
<?php echo 'var showeddays = ["'.date("d.m.Y",time()).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-86400).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-(2*86400)).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-(3*86400)).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-(4*86400)).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-(5*86400)).'","'.date("d.m.Y",strtotime(date("d.m.Y",time()))-(6*86400)).'"];'; ?>
var i;
for (i = 0; i < showeddays.length; i++) { 
if(typeof(days[showeddays[i]])=="undefined") {
days[showeddays[i]] = 0;
}
}
ctx.fillText(showeddays[0],330,135);
ctx.fillText(showeddays[1],280,135);
ctx.fillText(showeddays[2],230,135);
ctx.fillText(showeddays[3],180,135);
ctx.fillText(showeddays[4],130,135);
ctx.fillText(showeddays[5],80,135);
ctx.fillText(showeddays[6],30,135);
ctx.fillStyle = "grey";
ctx.font = "10pt Arial";
ctx.fillText(parseInt(days["max"]),5,15);
ctx.fillRect(days["max"].toString().length * 8 + 5,10,1000,1);
ctx.fillText(parseInt(days["max"]) * 0.75,5,42);
ctx.fillRect((days["max"] * 0.75).toString().length * 8 + 5,38,1000,1);
ctx.fillText(parseInt(days["max"]) * 0.5,5,70);
ctx.fillRect((days["max"] * 0.5).toString().length * 8 + 5,65,1000,1);
ctx.fillText(parseInt(days["max"]) * 0.25,5,99);
ctx.fillRect((days["max"] * 0.25).toString().length * 8 + 5,93,1000,1);
ctx.fillStyle = "black";
ctx.beginPath();
ctx.moveTo(50,120-(110 / days["max"] * days[showeddays[5]]));
ctx.lineTo(110,120-(110 / days["max"] * days[showeddays[4]]));
ctx.lineTo(170,120-(110 / days["max"] * days[showeddays[3]]));
ctx.lineTo(230,120-(110 / days["max"] * days[showeddays[2]]));
ctx.lineTo(290,120-(110 / days["max"] * days[showeddays[1]]));
ctx.lineTo(350,120-(110 / days["max"] * days[showeddays[0]]));
ctx.stroke();
}
}
var isfocused = false;
if(parent.document.getElementById("map")) {
	parent.document.getElementById("map").addEventListener("mouseover",function() {
		isfocused = true;
	});
	parent.document.getElementById("map").addEventListener("mouseout",function() {
		isfocused = false;
	});
}
parent.addEventListener("keydown",function(e) {
	if(parent.document.getElementById("map")) {
		if(isfocused === true) {
			switch(e.keyCode) {
				case 37: scrollimgLeft(); break;
				case 38: scrollimgTop(); break;
				case 39: scrollimgRight(); break;
				case 40: scrollimgBottom(); break;
			}
			e.preventDefault();
		}
	}
});
]]>
</script>
<style>
circle {
fill: grey;
}
circle:hover {
fill:black;
}
text {
font-family:Arial;
fill:grey;
}
#country {
font-weight:bold;
}
#hits {
font-size:20pt;
}
#country {
font-size: 35pt;
}
.percents {
fill:darkgrey;
}
.zoom, .zoomtext, .scrolltext, .scroll {
cursor:pointer;
font-size:28px;
}
#ten {fill:#C7D1F8}
#twenty {fill:#B1BEF8}
#thirty {fill:#99AAF6}
#forty {fill:#8C9FEF}
#fifty {fill:#6C83E5}
#sixty {fill:#566DD9}
#seventy {fill:#445ED2}
#eighty {fill:#2E4DD3}
#ninety {fill:#0B2CC0}
</style></svg>
